# -------------------------- пример 1 --------------------------
def apply_func(func, strings):
    return list(map(func, strings))

def to_upper(string):
    return string.upper()

def to_lower(string):
    return string.lower()

list_of_words = ['ToDay', 'iS', 'a', 'sunnY', 'DAY']
convert_to_upper = apply_func(to_upper, list_of_words)
convert_to_lower = apply_func(to_lower, list_of_words)

print(convert_to_upper)  # Изход: ['TODAY', 'IS', 'A', 'SUNNY', 'DAY']
print(convert_to_lower)  # Изход: ['today', 'is', 'a', 'sunny', 'day']

# -------------------------- пример 2 --------------------------
def filter_list(condition, list):
    filtered = []
    for item in list:
        if condition(item):
            filtered.append(item)
    return filtered

def is_even(num):
    return num % 2 == 0

def is_odd(num):
    return num % 2 != 0

list_of_numbers = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20]
even_numbers = filter_list(is_even, list_of_numbers)
odd_numbers = filter_list(is_odd, list_of_numbers)

print(even_numbers)  # Изход: [2, 4, 6, 8, 10, 12, 14, 16, 18, 20]
print(odd_numbers)  # Изход: [1, 3, 5, 7, 9, 11, 13, 15, 17, 19]

# -------------------------- пример 3 --------------------------
def action1(text, num):
    return text + str(num)

def action2(num, text):
    return text + str(num)

# Сравняване на две функции за равенство
isEqual1 = action1("March", 2023) == action2(2023, "March")
isEqual2 = action1("Rain", 2024) == action2(2023, "Sun")

print(isEqual1) # Изход: True
print(isEqual2) # Изход: False

# -------------------------- пример 4 --------------------------
# Деклариране на функция greeting
def greeting(name):
    print("Hello, {name}!")

# Присвояване на функцията на променлива
my_greeting = greeting
my_greeting("Misho") # Изход: Hello, Misho!

# -------------------------- пример 5 --------------------------
# Функция, която приема друга функция като аргумент
def expression(operation, arg1, arg2):
    return operation(arg1, arg2)

def add(arg1, arg2):
    return arg1 + arg2

def multiply(arg1, arg2):
    return arg1 * arg2

# Продаване на функцията add/multiply като аргумент на функцията expression
print(expression(add, 15, 7)) # Изход: 22
print(expression(multiply, 3, 14)) # Изход: 42

# -------------------------- пример 6 --------------------------
# Функция, която връща друга функция
def concat_str(right):
    def inner(left):
        return left + right
    return inner

result = concat_str("Right")
print(result("Left"))  # Изход: LeftRight